/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.providers.IPigmentProvider;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.tags.ITag;

public final class NSSPigment
extends AbstractNSSTag<Pigment> {
    private NSSPigment(@Nonnull ResourceLocation resourceLocation, boolean isTag) {
        super(resourceLocation, isTag);
    }

    @Nonnull
    public static NSSPigment createPigment(@Nonnull PigmentStack stack) {
        return NSSPigment.createPigment((Pigment)stack.getType());
    }

    @Nonnull
    public static NSSPigment createPigment(@Nonnull IPigmentProvider pigmentProvider) {
        return NSSPigment.createPigment((Pigment)pigmentProvider.getChemical());
    }

    @Nonnull
    public static NSSPigment createPigment(@Nonnull Pigment pigment) {
        if (pigment.isEmptyType()) {
            throw new IllegalArgumentException("Can't make NSSPigment with an empty pigment");
        }
        return NSSPigment.createPigment(pigment.getRegistryName());
    }

    @Nonnull
    public static NSSPigment createPigment(@Nonnull ResourceLocation pigmentID) {
        return new NSSPigment(pigmentID, false);
    }

    @Nonnull
    public static NSSPigment createTag(@Nonnull ResourceLocation tagId) {
        return new NSSPigment(tagId, true);
    }

    @Nonnull
    public static NSSPigment createTag(@Nonnull TagKey<Pigment> tag) {
        return NSSPigment.createTag(tag.f_203868_());
    }

    protected boolean isInstance(AbstractNSSTag o) {
        return o instanceof NSSPigment;
    }

    @Nonnull
    public String getJsonPrefix() {
        return "PIGMENT|";
    }

    @Nonnull
    public String getType() {
        return "Pigment";
    }

    @Nonnull
    protected Optional<Either<HolderSet.Named<Pigment>, ITag<Pigment>>> getTag() {
        return this.getTag(MekanismAPI.pigmentRegistry());
    }

    protected Function<Pigment, NormalizedSimpleStack> createNew() {
        return NSSPigment::createPigment;
    }
}

